//Foust A. S.,Principles of Unit Operations, 2nd Edition, Wiley India (P.) Ltd., Delhi, 2010
//Chapter 13: Fundamentals of Transfer Mechanisms
//Example 13.1 Page 252
//Title: Pressure Drop Calculation
//--------------------------------------------------
model Ex13_1
//--------------------------------------------------
//Parameter Section
parameter Real L(unit ="ft")=100 "Length of Smooth Tube";
parameter Real D(unit = "ft")=3/12 "Diameter of Smooth Tube";
parameter Real v(unit = "ft/s")=8 "Mean Velocity of Oil";
parameter Real rho(unit = "lb/(ft^3)")=60 "Density of Oil";
//Viscosity of Oil = 5 cP,converted to fps units
parameter Real mu(unit = "lb/(ft.s)")=5*6.72e-4 "Viscosity of Oil";
parameter Real gc(unit = "ft/(s^2)")=32.2 "Gravitational constant";
//--------------------------------------------------
//Variable Section
Real NRe(unit = "NULL") "Reynolds Number";
Real delP(unit = "psi") "Pressure Drop";
//--------------------------------------------------
//Equation Section
equation
NRe = (D * v * rho)/mu;
//From Figure 13.1, friction factor,f=0.023 for the NRe obtained
delP = (0.023 * (v^2) * L * rho)/(2 * 144 * gc * D);
//Division by 144 is to convert Pressure drop obtained in lbf/(ft^2) to psi

end Ex13_1;