//Foust A. S.,Principles of Unit Operations, 2nd Edition, Wiley India (P.) Ltd., Delhi, 2010
//Chapter 13: Fundamentals of Transfer Mechanisms
//Example 13.15 Page 294
//Title: Condensation Rate in Vertical Tube
//----------------------------------------------------
model Ex13_15
//----------------------------------------------------
//Parameter Section
parameter Real d(unit= "ft")=1/12 "Tube diameter";
parameter Real l(unit = "ft")=36/12 "Tube Length";
parameter Real Tv(unit = "degF")=212 "Steam Saturation Temperature";
parameter Real T1(unit = "degF")=90 "Tube surface Temperature";
parameter Real g(unit = "ft/s2")=32.2 "Gravitational Acceleration";
//At mean film temperature Tf, water properties
parameter Real mu(unit = "lb/(ft.hr)")=0.56*2.42 "Viscosity";
parameter Real rho_l(unit = "lb/ft3")=62 "Density";
parameter Real k(unit = "Btu/(hr.ft.degF")=0.368 "Thermal Conductivity";
//At Tv,
parameter Real rho_v(unit = "lb/ft3")=0.0373 "Density of vapour";
parameter Real del_Hv(unit = "Btu/lb")=970.3 "Enthalpy of vapour";
//----------------------------------------------------
//Variable Section
Real Tf(unit = "degF") "Mean Film Temperature";
Real h(unit = "Btu/(hr.ft2.degF)") "Mean Heat Transfer Coefficient over tube length";
Real Q(unit = "Btu/hr") "Rate of Condensation";
Real w(unit = "lb/hr") "Mass flow rate of condensate";
Real NRe(unit = "") "Reynolds No.";
//----------------------------------------------------
//Library Section
extends Modelica.Constants;
//----------------------------------------------------
//Equation Section
equation
//Eqn 13.141
Tf = Tv - ((3/4) * (Tv-T1)) ;
//Assuming Laminar flow, by eqn 13.142,
h = 1.13 * ((((k^3) * rho_l * (rho_l - rho_v) * del_Hv * g * (3600^2))/(mu * l * (Tv-T1)))^(1/4));
Q = h * (pi*d*l) * (-(T1-Tv));
w = Q/del_Hv ;
NRe = (4*w)/(pi*d*mu);
//NRe is found to ascertain the assumption made earlier.

end Ex13_15;