//Foust A. S.,Principles of Unit Operations, 2nd Edition, Wiley India (P.) Ltd., Delhi, 2010
//Chapter 13: Fundamentals of Transfer Mechanisms
//Example 13.6 Page 261
//Title: Force Calculation
//--------------------------------------------------
model Ex13_6
//--------------------------------------------------
//Parameter Section
parameter Real H(unit = "ft")=100 "Height of Chimney";
parameter Real D(unit = "ft")=5 "Diameter of Chimney";
parameter Real vfs(unit = "miles/hr")=100 "Wind Velocity";
parameter Real rho(unit = "lb/(ft^3)")=0.075 "Density of Air";
parameter Real gc(unit = "ft/(s^2)")=32.2 "Gravity";
//For NRe > 5e+5
parameter Real cD(unit = "NULL")=0.33 "Drag Coefficient";
//Viscosity of Air = 0.018 cP,converted to fps units
parameter Real mu(unit = "lb/(ft.s)")=0.018*6.72e-4 "Viscosity of Air"; 
//--------------------------------------------------
//Variable Section
Real NRe(unit = "NULL") "Reynolds Number";
Real S(unit = "ft^2") "Maximum Projected Area normal to Flow";
Real FD(unit = "lbf") "Force Exerted on the Chimney by the Wind";
//--------------------------------------------------
//Equation Section
equation
NRe = (D * vfs * (88/60) * rho)/mu; //Conversion of miles to feet and hour to seconds
S = H * D; //Here, Maximum Projected Area = Rectangle's Area
FD = (cD * S * ((vfs *88/60)^2) * rho)/(2*gc);
end Ex13_6;