//Foust A. S.,Principles of Unit Operations, 2nd Edition, Wiley India (P.) Ltd., Delhi, 2010
//Chapter 14: Interphase Transfer
//Example 14.1 Page 307
//Title: Heat Loss through brick wall in furnace
//--------------------------------------------------
model Ex14_1
//--------------------------------------------------
//Parameter Section
parameter Real Tw(unit = "degF")=1800 "Temperature at the fire wall";
parameter Real To(unit = "degF")=120 "Temperature at the outer surface";
parameter Real del_x2(unit  = "ft")=(6/12) "Fire brick wall's thickness";
parameter Real del_x3(unit  = "ft")=(4/12) "Insulating brick wall's thickness";
parameter Real del_x4(unit  = "ft")=(4/12) "Common brick wall's thickness";
//Thermal Conductivities
parameter Real k2(unit = "Btu/(hr.(ft2).(degF/ft))")=0.95 "Fire Brick's k";
parameter Real k3(unit = "Btu/(hr.(ft2).(degF/ft))")=0.14 "Insulating Brick's k";
parameter Real k4(unit = "Btu/(hr.(ft2).(degF/ft))")=0.8 "Common Brick's k";
//Basis
parameter Real A(unit = "(ft2)")=1 "Heat Transfer Area";
//--------------------------------------------------
//Variable Section
Real R2(unit = "(degF.hr)/Btu") "Resistance of fire Brick";
Real R3(unit = "(degF.hr)/Btu") "Resistance of insulating Brick";
Real R4(unit = "(degF.hr)/Btu") "Resistance of common Brick";
Real sigma_R(unit = "(degF.hr)/Btu") "Total Resistance";
Real q(unit = "Btu/(hr.(ft2)") "Heat Flux";
Real T2(unit = "degF") "Temperature at the junction of fire brick and insulating brick";
Real T3(unit = "degF") "Temperature at the junction of insulating brick and common brick";
//--------------------------------------------------
//Equation Section
equation 
R2 = del_x2/(k2 * A);
R3 = del_x3/(k3 * A);
R4 = del_x4/(k4 * A);
sigma_R = R2 + R3 + R4;
q = -(To - Tw)/sigma_R;
//From equation 14.29
T2 = Tw - (q * R2);
T3 = T2 - (q * R3);

end Ex14_1;