//Foust A. S.,Principles of Unit Operations, 2nd Edition, Wiley India (P.) Ltd., Delhi, 2010
//Chapter 14: Interphase Transfer
//Example 14.2 Page 310
//Title: Heat transfer
//--------------------------------------------------
model Ex14_2
//--------------------------------------------------
//Parameter Section
parameter Real Tw(unit = "degF")=95 "Bulk Water Temperature";
parameter Real To(unit = "degF")=350 "Bulk Oil Temperature";
parameter Real ha(unit = "Btu/(hr.(ft2).degF")=100 "Heat transfer Coefficient for hot phase";
parameter Real hb(unit = "Btu/(hr.(ft2).degF")=400 "Heat transfer Coefficient for cold phase";
//From Appendix C,
parameter Real Da(unit = "ft")=1/12 "Diameter of inner tube";
parameter Real Db(unit = "ft")=0.902/12 "Diameter of outer pipe";
parameter Real del_x(unit  = "ft")=(0.049/12) "Tube Wall Thickness";
//From Appendic D
parameter Real k(unit = "Btu/(hr.(ft2).(degF/ft))")=215 "Copper's Thermal Conductivity";
//Basis
parameter Real L(unit = "ft")=1 "Tube Length";
//--------------------------------------------------
//Variable Section
Real Aa(unit = "(ft2)") "Heat Transfer Area for hot phase";
Real Ab(unit = "(ft2)") "Heat Transfer Area for cold phase";
Real Aam(unit = "(ft2)") "Mean Heat Transfer Area";
Real sigma_R(unit = "(degF.hr)/Btu") "Total Resistance";
Real q(unit = "Btu/(hr.(ft2)") "Heat transfer rate";
Real T2(unit = "degF") "Temperature of copper's outer surface";
//--------------------------------------------------
//Libraries Section
extends Modelica.Constants;
//--------------------------------------------------
//Equation Section
equation
Aa = pi * Da * L;
Ab = pi * Db * L;
//Since tube is thin-walled instead of logarithmic mean, arithmetic mean can be used
Aam = (Aa + Ab)/2 ;
//Total Resistance = 1/(UA) = sigma_R
sigma_R = (1/(hb * Ab)) + ((del_x)/(k * Aam)) + (1/(ha * Aa)) ; 

q = (-(Tw - To))/sigma_R ;

T2 = To - (q * (1/(ha * Aa))) ;

end Ex14_2;