//Foust A. S.,Principles of Unit Operations, 2nd Edition, Wiley India (P.) Ltd., Delhi, 2010
//Chapter 15: Heat Transfer
//Example 15.2 Page 338
//Title: Number of passes required
//--------------------------------------------------
model Ex15_2
//--------------------------------------------------
//Parameter Section
parameter Real d(unit = "ft")=0.622/12 "I.D of tube";
parameter Real L(unit = "ft")=6 "Length of tube";
parameter Real n(unit = "NULL")=10 "No. of tubes";
parameter Real T(unit = "degF")=212 "Boiling point";
parameter Real T1(unit = "degF")=70 "Initial Temperature";
parameter Real T2(unit = "degF")=180 "Final Temperature";
//From example 15.1
parameter Real w(unit = "lb/hr")=12600 "Mass flow rate of oil";
parameter Real cp(unit = "Btu/(lb.degF)")=0.48 "Specific heat of oil";
//At avaerage oil temperature = (T1+T2)/2 = 125 degF
parameter Real U(unit = "Btu/(hr.(ft2).degF")=37 "Heat Transfer Coefficient";
//--------------------------------------------------
//Variable Section
Real Ap(unit = "ft2") "Transfer area per pass";
Real q(unit = "Btu/hr") "Heat Load";
Real del_T_lm(unit = "degF") "Logarithmic Mean Temperature Difference";
Real A(unit = "ft2") "Total heat transfer area";
Real N(unit = "NULL") "No. of Passes";
//--------------------------------------------------
//Libraries Section
extends Modelica.Constants;
extends Modelica.Math;
//--------------------------------------------------
//Equation Section
equation 
Ap = pi * d * L * n;
q = w * cp * (T2 - T1);
del_T_lm = ((T-T1)-(T-T2))/log((T-T1)/(T-T2)) ;
A = q/(U * del_T_lm);
N = A/Ap;

end Ex15_2;