//Foust A. S.,Principles of Unit Operations, 2nd Edition, Wiley India (P.) Ltd., Delhi, 2010
//Chapter 15: Heat Transfer
//Example 15.6 Page 367
//Title: Condensation of steam
//--------------------------------------------------
model Ex15_6
//--------------------------------------------------
//Parameter Section
parameter Real Tp(unit = "degR")=788 "Pipe surface Temperature";
parameter Real T(unit = "degR")=500 "Temperature at warehouse";
parameter Real sigma(unit = "Btu/(hr.ft2.K4)")=0.173 "Stefan Boltzmann Constant for steel";
parameter Real hc(unit = "Btu/(hr.(ft2).degF")=2 "Heat Transfer Coeffcient by natural convection";
//For 2-in, schedule 40 steel pipe,
parameter Real A(unit = "ft2")=0.622 "Area of pipe's outer surface";
//From Appendix D-15,
parameter Real e(unit = "NULL")=0.95 "Surface Emissivity of steel";
//--------------------------------------------------
//Variable Section
Real q(unit = "Btu/hr") "Total Thermal Energy Loss";
Real Rc(unit = "lb/(hr.ft)") "Rate of condensation";
//--------------------------------------------------
//Equation Section
equation 
q = (e * (1/100)^4 * A * sigma * ((Tp^4)-(T^4))) + (hc * A * (Tp-T));
//For del_H=888.8 Btu/lb,
Rc = q/888.8 ;

end Ex15_6;