//Foust A. S.,Principles of Unit Operations, 2nd Edition, Wiley India (P.) Ltd., Delhi, 2010
//Chapter 16: Mass Transfer
//Example 16.3 Page 401
//Title: Scrubbing of SO2 Gas Mixture
//--------------------------------------------------
model Ex16_3
//--------------------------------------------------
//Parameter Section
parameter Real G_v(unit = "lb/hr")=1000 "Vapour phase flow rate";
parameter Real y1(unit = "")=0.06 "Inlet SO2 Concentration(Vapour)";
parameter Real y2(unit = "")=0.001 "Exit SO2 Concentration(Vapour)";
//From figure 16.13
parameter Real x1(unit = "")=0.00174 "Inlet SO2 Concentration(Liquid)";
//For SO2 in water, at 87degF & 1atm
parameter Real mu_L(unit = "lb/(ft.s)")=1 "Liquid phase viscosity";
parameter Real rho_L(unit = "lb/ft3")=62.2 "Liquid phase density";
//For SO2 in air, at 87degF & 1atm
parameter Real rho_v(unit = "lb/ft3")=0.0726 "Vapour phase density";
parameter Real g(unit = "ft/s2")=4.18e+8 "Gravitational acceleration";
//From Table 16.1, For 1-in ceramic Raschig Rings,
parameter Real Fp(unit = "")=160 "Packing Factor";
//From example 16.2
parameter Real H_G(unit = "ft")=0.51 "HTU for vapour phase";
parameter Real H_L(unit = "ft")=3.296 "HTU for liquid phase";
//--------------------------------------------------
//Variable Section
Real V(unit = "lbmol/hr") "Total gas flow rate";
Real V1(unit = "lbmol/hr") "Vapour Flow rate-solute free basis";
Real L1(unit = "lbmol/hr") "Minimum Water rate-solute free basis";
Real L1act(unit = "lbmol/hr") "Actual water rate";
Real x1act(unit = "") "Actual Inlet SO2 Concentration(Liquid)";
Real S_ab(unit = "lb/hr") "Amount of SO2 absorbed";
Real G_L(unit = "lb/hr") "Amount of water entering";
Real L(unit = "lb/hr") "Total amount of liquid leaving";
Real G_vf(unit = "lb/(hr.ft2)") "Vapour rate at Flooding";
Real G_vo(unit = "lb/(hr.ft2)") "Vapour rate at operating condition";
Real A(unit = "ft2") "Cross-sectional area of scrubber";
Real D(unit = "ft") "Scrubber diameter";
Real G_Lo(unit = "lb/(hr.ft2)") "Liquid Rate at Operating condition";
Real H_og(unit = "ft") "Height of transfer units";
Real N_og(unit = "") "Number of transfer units";
Real z(unit = "ft") "Height of scrubber";
//--------------------------------------------------
//Libraries Section
extends Modelica.Constants;
extends Modelica.Math;
//--------------------------------------------------
//Equation Section
equation
//MW of SO2 & air are 64 & 29 resp.
V = G_v/((64*y1)+((1-y1)*29)) ;
V1 = V*(1-y1) ;
//Operating Line Equation
//Since fresh water is used, x2=0
V1*((y2/(1-y2))-(y1/(1-y1))) = L1 * (0-(x1/(1-x1))) ;
L1act = 2*L1 ;
V1*((y2/(1-y2))-(y1/(1-y1))) = L1act * (0-(x1act/(1-x1act))) ;
//SO2 absorbed = SO2 entered - SO2 leaving
S_ab = (V*y1*64) - (V1*64*(y2/(1-y2))) ;
G_L = L1act * 18;
L = G_L + S_ab;
//From fig.16.12, for (G_L/G_v)*sqrt(rho_v/rho_L) = 1.33,
G_vf = sqrt((0.015*g*rho_v*rho_L)/(Fp*(mu_L^0.2))) ;
G_vo = 0.5 * G_vf;
A = G_v/G_vo ;
D = sqrt((4*A)/pi);
G_Lo = L1act * 18/A ;
//Using least squares equation, from fig16.13, slope of equilibrium curve eqn=m=25.7
//By eqn 16.44
H_og = H_G + (25.7*G_vo*H_L/G_Lo) ;
//Dilute solution-->Eqn. 16.41: y2*=0 and y1*=0.022
N_og = (y2-y1) / (((0-y2)-(0.022-y1))/log((0-y2)/(0.022-y1)));
//Height of tower
z = H_og * N_og;
//Pressure drop in tower is 1-in of water w.r.to the ordinate value & fig16.12

end Ex16_3;