//Foust A. S.,Principles of Unit Operations, 2nd Edition, Wiley India (P.) Ltd., Delhi, 2010
//Chapter 18: Simultaneous Heat and Mass Transfer-Drying
//Example 18.3 Page 473
//Title: Rotary Dryer for TiO2
//--------------------------------------------------
model Ex18_3
//--------------------------------------------------
//Parameter Section
parameter Real rho_s(unit = "lb/ft3")=240 "Density of solids";
parameter Real rho(unit = "lb/ft3")=0.05 "Density of air";
parameter Real D(unit = "ft")=5 "Dryer Diameter";
parameter Real d(unit = "microns")=50 "Particle Diameter";
parameter Real L(unit = "ft")=60 "Dryer Length";
parameter Real s(unit = "ft/ft")=0.05 "Slope of dryer";
parameter Real mu(unit = "lb/(ft.s)")=0.02*6.72e-4 "Viscosity of air";
parameter Real Gv(unit = "lb/(hr.ft2)")=50 "Gas Flow Rate";
parameter Real X0(unit = "lb.water/lb.dry dolids")=0.3 "Initial Moisture Content";
parameter Real Xf(unit = "lb.water/lb.dry dolids")=0.02 "Final Moisture Content";
parameter Real N(unit = "rpm")=4 "Dryer speed";
parameter Real g(unit = "ft/s2")=32.2 "Gravitational acceleration";
parameter Real lambda(unit = "Btu/lb")=1019 ;
parameter Real cp(unit = "Btu/(lb.degF)")=7.13 "Specific Heat of TiO2 at Ta";
//--------------------------------------------------
//Variable Section
Real vt(unit = "ft/s") "Maximum settling velocity";
Real NRe(unit = "") "Reynolds Number";
Real A(unit = "") "Term in eqn to find feed rate";
Real B(unit = "") "Term in eqn to find feed rate";
Real C(unit = "") "Term in eqn to find feed rate";
Real Gf(unit = "lb/(hr.ft2)") "Feed rate to dryer";
Real Greq(unit = "lb/(hr.ft2)") "Required feed rate";
Real T1(unit = "degF");
Real q(unit = "Btu/lb.air") "Heat Load";
Real Q(unit = "Btu/(hr.ft2)") "Heat Transfer Rate";
Real X(unit = "") "Term in eqn to find Heat transfer coefficient";
Real Y(unit = "") "Term in eqn to find Heat transfer coefficient";
Real Ua(unit = "Btu/(hr.degF.ft3)") "Volumetric Overall Heat Transfer Coefficient";
Real delta_T_lm(unit = "degF") "Required log mean T Difference";
//--------------------------------------------------
//Equation Section
equation
//By eqn 22.15
vt = ((rho_s - rho) * g *((d*1e-4/(2.54*12))^2))/(18 * mu) ;
NRe = ((d*1e-4/(2.54*12)) * vt * rho)/mu ;
//Assuming 5% solid loading and by eqn 18.16
A = (0.05*60*L*rho_s);
B = (3.12*L*Gv)/(d^0.5) ;
C = (0.35*L)/(s*(N^0.9)*D);
Gf = (A - B) / C ;
Greq = Gv/(X0-Xf);
//Assuming moisture pickup as 0.1 lb water/lb dry solid, Ta=130 degF
(T1 - 130) = ((0.1*29/18) * lambda *18)/cp ;
q = 0.1 * lambda;
Q = q * Gv;
//By eqn 18.17
X = (0.63 * (Gv^0.16))/D;
Y = 5.2*Gv*rho_s/(d^0.5);
Ua = X * ((Greq + Y)^0.5) ;
delta_T_lm = Q/(Ua * L);

end Ex18_3;