//Foust A. S.,Principles of Unit Operations, 2nd Edition, Wiley India (P.) Ltd., Delhi, 2010
//Chapter 19:Simultaneous Heat and Mass Transfer-Evaporation & Crystallization
//Example 19.1 Page 501
//Title: Heating area required
//--------------------------------------------------
model Ex19_1
//--------------------------------------------------
//Parameter Section
parameter Real xF(unit = "NULL")=0.1 "Mole fraction of NaOH in feed";
parameter Real x1(unit = "NULL")=0.5 "Mole fraction of NaOH in product";
parameter Real L1(unit = "lb/hr")=10000 "Product flow rate";
parameter Real lambda_v0(unit = "Btu/lb")=920 "Latent heat of evaporation";
parameter Real hF(unit = "Btu/lb")=60 "Enthalpy/unit mass of feed";
parameter Real H1(unit = "Btu/lb")=1160 "Enthalpy/unit mass of vapour";
parameter Real h1(unit = "Btu/lb")=245 "Enthalpy/unit mass of liquid stream";
parameter Real del_T(unit = "K")=64 "Temperature difference";
//--------------------------------------------------
//Variable Section
Real F(unit = "lb/hr") "Feed Rate";
Real V1(unit = "lb/hr") "Exit vapour rate";
Real V0(unit = "lb/hr") "Vapour feed rate";
Real A(unit = "ft2") "Heating area";
//--------------------------------------------------
//Equation Section
equation
F * xF = L1 * x1;
V1 = F - L1;
(V0 * lambda_v0) + (F*hF) = (V1*H1) + (L1*h1);
//When overall heat transfer coefficient,U=500
(V0 * lambda_v0) = 500 * A * del_T ;

end Ex19_1;