//Foust A. S.,Principles of Unit Operations, 2nd Edition, Wiley India (P.) Ltd., Delhi, 2010
//Chapter 20: The Energy Balance in Flow Systems
//Example 20.7 Page 575
//Title: Power requirement-Agitation with single blade turbine
//--------------------------------------------------
model Ex20_7
//--------------------------------------------------
//Parameter Section
parameter Real rho(unit = "lb/ft3")=62.3 "Density of liquid";
parameter Real D(unit = "ft")=1 "Diameter of Impeller";
parameter Real gc(unit = "lbm.ft/(lbf.s2)")=32.2 "Conversion factor";
parameter Real NRe(unit = "")=270 "Reynolds no.";
//For both (a) Pseudoplastic fluid and (c) Dilatant fluid,
parameter Real K(unit = "")=1 "Consistency Index";
//For (b) Newtonian fluid
parameter Real mu_N(unit = "lb/(ft.s)")=1 "Viscosity";
//Flow index for [1]pseudoplastic and [2]dilatant fluids
parameter Real[2] n(each unit = "")={0.9,1.1} "Flow index";
//--------------------------------------------------
//Variable Section
Real[3] N(each unit = "rev/s") "Impeller Speed";
Real[2] mu(each unit = "lb/(ft.s)") "Viscosity";
Real[3] P(each unit = "hp") "Power requirement";
//--------------------------------------------------
//Equation Section
equation
//The array positions [1],[2] & [3] refer to pseudoplastic, dilatant & Newtonian fluids resp.
//The conditions used are of curve 4 in fig.20.25
//At NRe=270, from fig.20.25, Power no.=3.7 for the fluids as the curves coincide at this region
//Pseudoplastic fluid
(D^2)*N[1]*rho/NRe = K * ((11*N[1])^(n[1]-1)) ;
mu[1] = (D^2)*N[1]*rho/NRe ;
P[1] = (3.7*rho*(N[1]^3)*(D^5))/(550*gc) ;
//Dilatant Fluid
N[2] ^ (2-n[2]) = (NRe * (11^(n[2]-1)) * K)/((D^2)*rho) ;
mu[2] = (D^2)*N[2]*rho/NRe ;
P[2] = (3.7*rho*(N[2]^3)*(D^5))/(550*gc) ;
//Newtonian Fluid
N[3] = (NRe * mu_N)/(rho * (D^2));
P[3] = (3.7*rho*(N[3]^3)*(D^5))/(550*gc) ;

end Ex20_7;