//Foust A. S.,Principles of Unit Operations, 2nd Edition, Wiley India (P.) Ltd., Delhi, 2010
//Chapter 22: Particulate solids flow and separation through fluid mechanics
//Example 22.10 Page 652
//Title: Pressure Drop in Black Mesa Pipeline
//--------------------------------------------------
model Ex22_11
//--------------------------------------------------
//Parameter Section
parameter Real D(unit = "ft")=18/12 "Particle Diameter";
parameter Real L(unit = "ft")=5280 "Length of pipeline";
parameter Real m(unit = "ton/year")=5.5e+6 "Coal Supplied";
parameter Real C(unit = "")=0.5 "Wt.% of slurry";
//rho_medium=1 g/cm3 & rho_s = 1.35 g/cm3
parameter Real rho(unit = "lb/ft3")=1.175*62.4 "Density of slurry";
parameter Real s(unit = "")=1.35 "Density Ratio";
//From fig.22.1
parameter Real CD_f(unit = "")=600 "Free-fall Drag Coefficient";
parameter Real g(unit = "ft/s2")=32.2 "Gravitational Acceleration";
//Constants for Eqn 22.107
//Array positions  1 to 6 refer to equations designated as a to f resp.
//Here, a',b',c' and d' are referred to as a,b,c and d resp.
parameter Real[6] a(each unit = "")={31.93,2.411,1.167,0.4608,0.3703,0.2859}; 
parameter Real[6] b(each unit = "")={1.083,0.2263,0.5153,-0.3225,0.3183,1.075};
parameter Real[6] c_(each unit = "")={1.064,-0.2334,-0.3820,-1.065,-0.8837,-0.67};
parameter Real[6] d(each unit = "")={-0.0616,-0.384,-0.5724,-0.05906,-0.7496,-0.9375};
//--------------------------------------------------
//Variable Section
Real G(unit = "lb/hr") "Mass Rate of slurry";
Real v(unit = "ft/s") "Bulk Mean Velocity";
Real velo_term(unit = "") "Refers to v2/(Dg(s-1))";
Real NRe(unit = "") "Reynolds No.";
Real X(unit = "") "fw/4gc";
Real[6] Rmn(each unit = "") "Regime Boundary Ratio";
Real f(unit = "") "Frictional loss";
Real del_P(unit = "psi/mile") "Pr. Drop per Mile";
//--------------------------------------------------
//Library Section
extends Modelica.Constants;
//--------------------------------------------------
//Equation Section
equation
G = (m*2000)/(C*365*24) ;
v = (G*4)/(3600 * pi * (D^2) * rho);
velo_term = (v^2)/(D*g*(s-1)) ;
//For water flow (rho=62.4 and mu=1*6.72e-4) in laminar region
NRe = D*v*62.4/(6.72e-4);
//For NRe value, from Appendix C-3, fw = 0.0125
//gc = 1
X = 0.0125/4;
//Eqn 22.107a
Rmn[1] = velo_term/(a[1]*(C^(b[1]))*(X^(c_[1]))*(CD_f^(d[1]))) ;
//Eqn 22.107b
Rmn[2] = velo_term/(a[2]*(C^(b[2]))*(X^(c_[2]))*(CD_f^(d[2]))) ;
//Eqn 22.107c
Rmn[3] = velo_term/(a[3]*(C^(b[3]))*(X^(c_[3]))*(CD_f^(d[3]))) ;
//Eqn 22.107d
Rmn[4] = velo_term/(a[4]*(C^(b[4]))*(X^(c_[4]))*(CD_f^(d[4]))) ;
//Eqn 22.107e
Rmn[5] = velo_term/(a[5]*(C^(b[5]))*(X^(c_[5]))*(CD_f^(d[5]))) ;
//Eqn 22.107f
Rmn[6] = velo_term/(a[6]*(C^(b[6]))*(X^(c_[6]))*(CD_f^(d[6]))) ;
//Large Rmn value means velocity greater than transition velocity
//Eqn 22.107d has smallest Rmn value
//Hence Eqn 22.106d to find frictional loss
(f-0.0125)/(2*g) = 0.8444*(C^0.5024)*((X/g)^1.428)*(CD_f^0.1516)*(velo_term^(-0.3531)) ;
//Pressure drop per mile
del_P = f*rho*(v^2)*5280/(2*32.2*D*144) ;

end Ex22_11;