//Foust A. S.,Principles of Unit Operations, 2nd Edition, Wiley India (P.) Ltd., Delhi, 2010
//Chapter 22: Particulate solids flow and separation through fluid mechanics
//Example 22.2 Page 616
//Title: Seperation of Silica and Galena 
//--------------------------------------------------
model Ex22_2
//--------------------------------------------------
//Parameter Section
parameter Real rho(unit = "kg/(m^3)")=1000 "Density of Water";
parameter Real rho_g(unit = "kg/(m^3)")=7500 "Density of galena";
parameter Real rho_s(unit = "kg/(m^3)")=2650 "Density of silica";
parameter Real Dp(unit = "m")=0.0007 "Particle diameter";
parameter Real psi(unit = "NULL")=0.806 "Sphericity";
//At 20 degC,
parameter Real mu(unit = "(N.s)/(m^2)")=0.001 "Viscosity of water";
parameter Real g(unit = "m/(s^2)")=9.80665 "Acceleration due to gravity";
//--------------------------------------------------
//Variable Section
Real CD_1(unit = "NULL") "Drag coefficient (Silica-Water)";
Real v(unit = "m/s") "Water Velocity for pure Galena product";
Real CD_2(unit = "NULL") "Drag coefficient (Galena-Water)";
Real Dp_g(unit = "m") "Maximum Size Range of pure galena product";
//--------------------------------------------------
//Equation Section
equation
CD_1 =  (4 * g * (Dp^3) * rho * (rho_s - rho))/(3 * (mu ^ 2 ));
//For Reynolds number=1 and the above CD,
//From Fig.22.1, when the line intersects psi=0.806 line,Reynolds no=(Dp*vt*rho)/mu=28
//Water velocity to ensure clean galena product
v = (28 * mu)/(Dp * rho);

CD_2 =  (4 * g * mu * (rho_g - rho))/(3 * (rho ^ 2 ) * (v ^ 3));
//For Reynolds number=1 and the above CD,
//From Fig.22.1, when the line intersects psi=0.806 line,Reynolds no=(Dp*vt*rho)/mu=9
//Galena size range will be between Dp_g and 0.7 mm
Dp_g = (9 * mu)/(v * rho);

end Ex22_2;