//Foust A. S.,Principles of Unit Operations, 2nd Edition, Wiley India (P.) Ltd., Delhi, 2010
//Chapter 22: Particulate solids flow and separation through fluid mechanics
//Example 22.4 Page 628
//Title: Primary Refining of oils
//--------------------------------------------------
model Ex22_4
//--------------------------------------------------
//Parameter Section
parameter Real rho_l(unit = "g/(cm^3)")=0.92 "Density of oil";
parameter Real mu_l(unit = "cP")=(20*2.42) "Viscosity of oil";
parameter Real rho_h(unit = "g/(cm^3)")=0.98 "Density of soap";
parameter Real mu_h(unit = "cP")=(300*2.42) "Viscosity of soap";
parameter Real n(unit = "rpm")=18000 "Rotatonal Speed";
//50 gal/hr feed, containing 10 volume percent soap phase
parameter Real Q(unit = "(ft^3)/s")=(5/(7.48*3600)) "Volumetric flow rate";
//Radii of dams over which the phases flow
parameter Real r4(unit = "in")=0.51 "Heavy phase";
parameter Real r1(unit = "in")=0.5 "Light phase";
//--------------------------------------------------
//Variable Section
Real r2(unit = "in") "Radius to liquid-liquid interface";
Real omega(unit = "rad/s") "Angular velocity of centrifuge";
Real V(unit = "(ft^3)") "Volume of Centrifuge";
Real tr(unit = "s") "Residence Time";
Real Dp(unit = "ft") "Critical Droplet size";
//--------------------------------------------------
//Library Section
extends Modelica.Constants;
extends Modelica.Blocks.Math;
//--------------------------------------------------
//Equation Section
equation
r2 = sqrt(((rho_h * (r4^2)) - (rho_l * (r1^2)))/(rho_h - rho_l));
omega = (2*pi*n*60)^2;
//Tubular bowl centrifuge: h=30 in and r=1 in
V = (30 * pi * (1-(r2^2)))/1728;
tr = V/Q;
Dp = sqrt(((9*mu_h*3600)/(62.4*(rho_h - rho_l)*omega*tr)) * (2* log(1/r2))); 

end Ex22_4;