//Foust A. S.,Principles of Unit OPerations, 2nd Edition, Wiley India (P.) Ltd., Delhi, 2010
//Chapter 3: Phase Relations
//Example 3.1 Page 32
//Title: Liquid & Vapour compositions
//------------------------------------
package Ex3_1
//------------------------------------

  model Ex3_1_a
//------------------------------------
    //Parameter Section
    parameter Real P(unit = "kN/m^2") = 300 "Total Pressure";
    parameter Real Pb(unit = "kN/m^2") = 373 "Vapour Pressure of Butane at 40 degC";
    parameter Real Pp(unit = "kN/m^2") = 117 "Vapour Pressure of Pentane at 40 degC"; //------------------------------------
    //Variable  Section
    Real xb(unit = "NULL") "Mole fraction of Butane in liquid phase";
    Real xp(unit = "NULL") "Mole fraction of Pentane in liquid phase";
    Real yb(unit = "NULL") "Mole fraction of Butane in vapour phase";
    Real yp(unit = "NULL") "Mole fraction of Pentane in vapour phase";
//------------------------------------
    //Equation Section
    equation
     //Equilibrium
    xb + xp = 1;
    yb + yp = 1;
     // Raoult's Law
    yb = Pb / P * xb;
    yp = Pp / P * xp;
    
  end Ex3_1_a;
//------------------------------------

  model Ex3_1_b
//------------------------------------
    //Parameter Section
    parameter Real Kb(unit = "NULL") = 1.2 "Equilibrium Constant for Butane";
    parameter Real Kp(unit = "NULL") = 0.38 "Equilibrium Constant for Pentane";
//------------------------------------
    //Variable  Section
    Real xb(unit = "NULL") "Mole fraction of Butane in liquid phase";
    Real xp(unit = "NULL") "Mole fraction of Pentane in liquid phase";
    Real yb(unit = "NULL") "Mole fraction of Butane in vapour phase";
    Real yp(unit = "NULL") "Mole fraction of Pentane in vapour phase";
//------------------------------------
    //Equation Section
    equation
     //Equilibrium
    xb + xp = 1;
    yb + yp = 1;
    //Equilibrium Relation
    yb = Kb * xb;
    yp = Kp * xp;
  
  end Ex3_1_b;
//------------------------------------

end Ex3_1;