//Foust A. S.,Principles of Unit OPerations, 2nd Edition, Wiley India (P.) Ltd., Delhi, 2010
//Chapter 3: Phase Relations
//Example 3.3 Page 33
//Title: Dew Point Temperature
//------------------------------------
model Ex3_3
//------------------------------------
//Parameter Section
//Mixture Composition
parameter Real xb(unit = "NULL")=0.2 "Mol% Benzene";
parameter Real xt(unit = "NULL")=0.3 "Mol% Toluene";
parameter Real xx(unit = "NULL")=0.5 "Mol% o-Xylene";
parameter Real P(unit = "kN/m^2")=100 "Total Pressure";
//Antoine's Constants
//Array positions 1,2 & 3 refer to Benzene, Toluene and o-Xylene resp.
parameter Real[3] A(each unit = "")={6.90565,6.95464,6.99891} ;
parameter Real[3] B(each unit = "")={1211.033,1344.8,1474.679} ;
parameter Real[3] C(each unit = "")={220.79,219.482,213.686} ;
//------------------------------------
//Variable  Section
Real T(unit = "C") "Dew Point Temperature";
//--------------------------------------------------
//Library Section
extends Modelica.Math;
//------------------------------------
//Equation Section
equation
//Material Balance + Raoult's Law + Antoine's Equation Page 34
(xb * (10^(A[1]-(B[1]/(C[1]+T))))) + (xt * (10^(A[2]-(B[2]/(C[2]+T))))) + 
(xx * (10^(A[3]-(B[3]/(C[3]+T))))) = P ;

end Ex3_3;