//Foust A. S.,Principles of Unit Operations, 2nd Edition, Wiley India (P.) Ltd., Delhi, 2010
//Chapter 7: Simplified Calculation Methods
//Example 7.3 Page 110
//Title: Distillate-Quantity & Average Composition
//------------------------------------------------
model Ex7_3
//------------------------------------------------
//Parameter Section
parameter Real F(unit = "lb moles")=100 "Total Feed";
parameter Real xF(unit = "NULL")=0.2 "Ethanol Composition in Feed";
parameter Real xFW(unit = "NULL")=0.8 "Water Composition in Feed";
parameter Real R(unit = "NULL")=3 "Reflux Ratio";
parameter Real xB(unit = "NULL")=0.03  "Ethanol Composition in Bottom";
//------------------------------------------------
//Variable Section
Real xDav(unit = "NULL") "Average Composition of Ethanol in Distillate";
Real D(unit = "lb moles") "Quantity of Distillate";
Real B(unit = "lb moles") "Quantity of Bottom Product";
//------------------------------------------------
//Library Section
extends Modelica.Math;
//------------------------------------------------
//Equation Section
equation
log (100/B) = 0.275;
F = D + B;
xDav = ((F*xF) - (B*xB))/D;

end Ex7_3;