//Foust A. S.,Principles of Unit Operations, 2nd Edition, Wiley India (P.) Ltd., Delhi, 2010
//Chapter 9: Molecular Transport Mechanism
//Example 9.13 Page 182
//Title: Mass Diffusivity of ethanol in water at 10 degC
//------------------------------------------------------
model Ex9_13
//------------------------------------------------------
//Parameter Section
parameter Real T(unit = "K")=283 "Temperature 10 degC";
parameter Real M(unit = "kg/mol")=18e-3 "Molecular mass of water";
//For water. phi=1, hence from Appendix D-8
parameter Real mu(unit = "kg/(m.s)")=0.1308 "Viscosity of water";
parameter Real F(unit = "(K (s^2)/(kg.m))")=2.4e+12 "Function of molar volume";
parameter Real chi(unit = "NULL")=2.6 "Association Parameter of water";
//From Appendix D-7,
parameter Real C(unit = "(m^3)/mol")=14.8e-6 "Atomic volume of Carbon";
parameter Real H(unit = "(m^3)/mol")=3.7e-6 "Atomic volume of Hydrogen";
parameter Real O(unit = "(m^3)/mol")=7.4e-6 "Atomic volume of Oxygen";
//------------------------------------------------------
//Variable Section
Real V(unit = "(m^3)/mol") "Molar volume of Ethanol";
Real D1(unit = "(m^2)/s") "Diffusivity by eqn 9.59";
Real D2(unit = "(m^2)/s") "Diffusivity by eqn 9.60";
//------------------------------------------------------
//Library Section
extends Modelica.Blocks.Math;
//------------------------------------------------------
//Equation Section
equation
V = (2*C) + (5*H) + O;
//From equation 9.59
D1 = T/(F * mu);
//From equation 9.60
D2 = (5.88e-15 * sqrt(chi * M) * T) / (mu * (V^0.6)) ;

end Ex9_13;