//Foust A. S.,Principles of Unit Operations, 2nd Edition, Wiley India (P.) Ltd., Delhi, 2010
//Chapter 9: Molecular Transport Mechanism
//Example 9.4 Page 175
//Title: Argon-Properties
//------------------------------------------------
model Ex9_4
//------------------------------------------------
//Parameter Section
parameter Real mu1(unit = "kg/(m.s)")=2.096e-5 "Viscosity of Argon at 0 degC and 1 atm";
parameter Real T1(unit = "K")=273 "Temperature 0 degC";
parameter Real T2(unit = "K")=673 "Temperature 400 degC";
parameter Real M(unit = "kg/mol")=39.9e-3 "Molecular Weight of Argon";
parameter Real P(unit  = "N/(m^2)")=1.013e+5 "Atmospheric pressure";
//------------------------------------------------
//Variable Section
Real sigma(unit = "m") "Equivalent Molecular Diameter";
Real mu2(unit = "kg/(m.s)") "Viscosity at 400 degC and 1 atm";
Real D(unit = "(m^2)/s") "Mass Diffusivity of Argon at 0 degC and 1 atm";
Real k(unit = "J/(s.(m^2))(degC/m)") "Thermal Conductivity of Argon at 0 degC and 1 atm";
//------------------------------------------------
//Library Section
extends Modelica.Blocks.Math;
//------------------------------------------------
//Equation Section
equation
sigma = sqrt((5.79e-25 * sqrt(M * T1))/mu1);
mu2 = mu1 * sqrt(T2/T1);
D = (4.81e-24 * (T1^(3/2)))/(P * (sigma^2) * sqrt(M));
k = (1.203e-23 * sqrt(T1/M))/(sigma^2);

end Ex9_4;