//Foust A. S.,Principles of Unit Operations, 2nd Edition, Wiley India (P.) Ltd., Delhi, 2010
//Chapter 10:Differential Mass, Heat and Momentum Balances
//Example 10.1 Page 194
//Title: Two parallel flat plates
//--------------------------------------------------
model Ex10_1
//--------------------------------------------------
//Parameter Section
parameter Real x1(unit = "ft")=0;
parameter Real x2(unit = "ft")=(2/12) "Distance between the plates";
parameter Real x3(unit = "ft")=(0.5/12) "Distance from plate 1";
parameter Real x4(unit = "ft")=(1.5/12) "Distance from plate 2";
parameter Real v1(unit = "ft/min")=10 "Velocity of plate 1";
parameter Real v2(unit = "ft/min")=-35 "Velocity of plate 2 in opposite direction";
parameter Real mu(unit = "lb/(ft.hr)")=363 "Viscosity of Fluid between the plates";
parameter Real gc(unit = "ft/(hr^2)")=4.17e+08 "Acceleration due to gravity";
//--------------------------------------------------
//Variable Section
Real tauy(unit = "lbf/(ft^2)") "Shear stress on each plate at a distance y";
Real v3(unit = "ft/min") "Fluid Velocity w.r. to plate 1";
Real v4(unit = "ft/min") "Fluid Velocity w.r. to plate 2";
//--------------------------------------------------
//Equation Section
equation
//By equation 10.28
tauy = -(mu/gc)*((60*(v2-v1))/(x2-x1));
//By equation 10.30
v3 = v1 + ((v2-v1) * (x3/x2));
v4 = v1 + ((v2-v1) * (x4/x2));

end Ex10_1;