//Foust A. S.,Principles of Unit Operations, 2nd Edition, Wiley India (P.) Ltd., Delhi, 2010
//Chapter 10:Differential Mass, Heat and Momentum Balances
//Example 10.3 Page 196
//Title: Heat Loss per foot length of pipe
//--------------------------------------------------
model Ex10_3
//--------------------------------------------------
//Parameter Section
parameter Real r1(unit = "ft")=(1/12) "Distance from centre till coating's inside";
parameter Real r2(unit = "ft")=(3/12) "Distance from centre till coating's outside";
parameter Real T1(unit = "degF")=350 "Outer surface temperature of pipe";
parameter Real T2(unit = "degF")=100 "Outer surface temperature of coating";
//--------------------------------------------------
//Variable Section
Real q(unit = "Btu/hr") "Heat loss per pipe foot length";

// Thermal Conductivity of coating varies as,
// k = 0.5 + (5e-4 * T) --> T is in degF &  k is in Btu/(hr.(ft2).(degF/ft))
Real k(unit = "Btu/(hr.(ft2).(degF/ft))") "Thermal Conductivity of coating";

//--------------------------------------------------
//Library section
extends Modelica.Constants;
extends Modelica.Math;
//--------------------------------------------------
//Equation Section
equation
//By integration of eqn 9.21 (Fourier's Law)
k = (0.5 * (T1- T2)) + ((5e-4/2) * ((T1^2) - (T2^2)));
//For L=1 ft
q = ((2 * pi) * k)/(log(r2/r1));

end Ex10_3;