//Foust A. S.,Principles of Unit Operations, 2nd Edition, Wiley India (P.) Ltd., Delhi, 2010
//Chapter 10:Differential Mass, Heat and Momentum Balances
//Example 10.5 Page 204
//Title: Oil in Laminar flow
//--------------------------------------------------
model Ex10_5
//--------------------------------------------------
//Parameter Section
parameter Real D(unit = "in")=0.5 "Diameter of tube";
parameter Real Q(unit = "ft3/s")=(6/(7.48*60)) "Flow rate of oil";
parameter Real mu(unit = "Pa.s")=(300*0.000672) "Viscosity of oil";
parameter Real gc(unit = "ft/s2")=32.2 "Acceleration due to gravity";
//--------------------------------------------------
//Variable Section
Real r1(unit = "in") "Radius of tube";
Real vbar(unit = "ft/s") "Average Velocity";
Real delP(unit = "lb/ft2") "Pr. Drop per pipe foot length";
Real Tau_y(unit = "lb/ft2") "Wall Stress";
Real v(unit = "ft/s") "Point Velocity";
Real r(unit = "in") "Radial Position at which v=vbar";
//--------------------------------------------------
//Library section
extends Modelica.Constants;
extends Modelica.Math;
//--------------------------------------------------
//Equation Section
equation
r1 = D/2;
vbar = (4*Q)/(pi * ((D/12)^2)) ; 
//From eqn 10.94
delP = (32 * vbar * mu)/(gc * ((D/12)^2));
//From eqn 10.86
Tau_y = delP * r1/24;
//At r=0, from eqn 10.95
v = 2 * vbar;
//When v = vbar, from eqn 10.95
r = r1 * sqrt(1-0.5);

end Ex10_5;