//Foust A. S.,Principles of Unit Operations, 2nd Edition, Wiley India (P.) Ltd., Delhi, 2010
//Chapter 11: Equations of Change
//Example 11.5 Page 224
//Title: Temperature at Center plane of Slab from figure
//-------------------------------------------------------
model Ex11_5
//-------------------------------------------------------
//Parameter Section
parameter Real T_0(unit = "degC")=540 "Initial Temperature";
parameter Real T1(unit = "degC")=100 "Temperature of external surfaces at time zero";
parameter Real theta(unit = "s")=1800 "Time";
parameter Real x1(unit = "m")=0.15 "(Thickness of slab)/2";
parameter Real x(unit = "m")=0.075 "Point from the center plane";
parameter Real alpha(unit = "(m^2)/s")=9e-06 "Thermal Diffusivity";
//--------------------------------------------------
//Variable Section
Real T_1(unit = "degC") "Temperature at  center plane of slab";
Real T_2(unit = "degC") "Temperature of slab at x1";
Real X(unit = "NULL") "Exponent Term";
Real n(unit = "NULL") "Parameter for graph";
//--------------------------------------------------
//Equation Section
equation
X = (alpha * theta)/(x1^2);
//At midplane n=0
//Y = (T1-T)/(T1-T_0)
//From Fig11.4a Y = 0.23
T_1 = T1 - (0.23 * (T1 - T_0));
n = x/x1;
//At 0.075 m from midplane
//Y = 0.17
T_2 = T1 - (0.17 * (T1 - T_0));

end Ex11_5;