//Foust A. S.,Principles of Unit Operations, 2nd Edition, Wiley India (P.) Ltd., Delhi, 2010
//Chapter 12: Turbulent-Transport Mechanism
//Example 12.1 Page 238
//Title: Point Velocity and Eddy Diffusivity
//--------------------------------------------------
model Ex12_1
//--------------------------------------------------
//Parameter Section
parameter Real r1(unit = "ft")=1/12 "Inside Radius of Tube";
parameter Real L(unit = "ft")=1 "Length of the tube";
parameter Real rho(unit = "lb/(ft^3)")=62.4 "Density of Water";
parameter Real mu(unit = "lb/(ft.s)")=6.72e-4 "Viscosity of Water";
parameter Real delP(unit = "lbf/(ft^2)")=10 "Pressure Drop";
parameter Real uplus_1(unit = "ft/s")=5 "uplus value at yplus=5";
parameter Real yplus_1(unit = "ft")=5 "Position from wall (laminar sub layer)";
parameter Real yplus_2(unit = "ft")=30 "Position from wall (Buffer layer)";
parameter Real gc(unit = "ft/(hr^2)")=32.2 "Gravity";
//--------------------------------------------------
//Variable Section
Real tauy1(unit = "lbf/(ft^2") "Wall Stress at distance y1";
Real ustar(unit = "ft/s") "Point Velocity parameter";
Real nu(unit = "(ft^2)/s") "Kinematic Viscosity";
//At yplus_1 = 5, by equation 12.23, uplus_1 = 5
Real v_1(unit = "ft/s") "Point Velocity at r";
Real r_1(unit = "ft") "Position from the pipe center";
//At yplus_2 = 30,
Real uplus_2(unit = "ft/s") "Generalized Velocity";
Real v_2(unit = "ft/s") "Point velocity at a position r";
Real r_2(unit = "ft") "Position from the pipe center";
Real Etau_1(unit = "(ft^2)/s") "Eddy Diffusivity";
//At r=0.5r1
Real yplus_3(unit = "ft") "Position from wall";
Real uplus_3(unit = "ft/s") "Generalized Velocity";
Real v_3(unit = "ft/s") "Point velocity at a position r";
Real Etau_2(unit = "(ft^2)/s") "Eddy Diffusivity";
//At tube centre, r=0
Real yplus_4(unit = "ft") "Position from wall";
Real uplus_4(unit = "ft/s") "Generalized Velocity";
Real v_4(unit = "ft/s") "Point velocity at a position r";
Real Etau_3(unit = "(ft^2)/s") "Eddy Diffusivity";
//--------------------------------------------------
//Library Section
extends Modelica.Constants;
extends Modelica.Math;
extends Modelica.Blocks.Math;
//--------------------------------------------------
//Equation Section
equation
nu = mu/rho;
tauy1 = (delP * pi * (r1^2))/(2 * pi * r1 * L);
ustar = sqrt((tauy1 * gc)/rho);
//At yplus_1 = 5, by equation 12.23, uplus = 5
v_1 = uplus_1 * 0.464; 
r_1 = r1 - ((yplus_1 * mu)/(ustar * rho));
//Eddy diffusivity is zero in this region
//At yplus_2 = 30, 
uplus_2 = -3.05 + (5 * log(yplus_2));
v_2 = uplus_2 * 0.464;
r_2 = r1 - ((yplus_2 * mu)/(ustar * rho));
//From equations 12.22 and 12.24
Etau_1 = ((r_2 * mu * yplus_2)/(5 * rho * r1)) - nu;
//When equation 12.25 is used to get dv/dr then Etau value is different
//At r=0.5r1
yplus_3 = (r1 * ustar * rho)/(2 * mu);
uplus_3 = 5.5 + (2.5 * log(yplus_3));
v_3 = uplus_3 * 0.464;
//From equations 12.22 and 12.25
Etau_2 = ((mu * yplus_3)/(2 * rho * 2.5)) - nu;
//At tube centre, r=0
yplus_4 = (r1 * ustar * rho)/mu ;
uplus_4 = 5.5 + (2.5 * log(yplus_4));
v_4 = uplus_4 * 0.464;
//From Equation 12.22 at r=0
// nu + Etau will be zero
Etau_3 = 0 - nu;

end Ex12_1;