//Foust A. S.,Principles of Unit Operations, 2nd Edition, Wiley India (P.) Ltd., Delhi, 2010
//Chapter 13: Fundamentals of Transfer Mechanisms
//Example 13.14 Page 293
//Title: Mounting of condenser
//----------------------------------------------------
model Ex13_14
//----------------------------------------------------
//Parameter Section
parameter Real d(unit= "ft")=1/12 "Tube diameter";
parameter Real l(unit = "ft")=3 "Tube Length";
parameter Real N(unit = "")=5 "No. of tubes";
parameter Real Tv(unit = "degF")=212 "Steam Saturation Temperature";
parameter Real T1(unit = "degF")=150 "Tube surface Temperature";
parameter Real g(unit = "ft/s2")=32.2 "Gravitational Acceleration";
//At mean film temperature Tf, water properties
parameter Real mu(unit = "lb/(ft.hr)")=0.87 "Viscosity";
parameter Real rho_l(unit = "lb/ft3")=60.6 "Density";
parameter Real cp(unit = "Btu/(lb.degF)")=1 "Specific Heat";
parameter Real k(unit = "Btu/(hr.ft.degF")=0.383 "Thermal Conductivity";
//At Tv,
parameter Real rho_v(unit = "lb/ft3")=0.014 "Density of vapour";
parameter Real del_Hv(unit = "Btu/lb")=970 "Enthalpy of vapour";
//----------------------------------------------------
//Variable Section
Real Tf(unit = "degF") "Mean Film Temperature";
Real del_rho(unit = "lb/ft3");
Real X(unit = "");
Real Y(unit = "");
Real Z(unit = "");
Real h_v(unit = "Btu/(hr.ft2.degF)") "Heat transfer coefficient-Vertical Mounting";
Real h_h(unit = "Btu/(hr.ft2.degF)") "Heat transfer coefficient-Horizontal Mounting";
//----------------------------------------------------
//Equation Section
equation
//Eqn 13.141
Tf = Tv - ((3/4) * (Tv-T1)) ;
del_rho = rho_l - rho_v;
X = (k^3) * rho_l * del_rho * del_Hv * g * (3600^2);
Y = mu * l * (Tv-T1);
Z = mu * d * (N^(2/3)) * (Tv-T1);
//For Vertical mounting of condenser, eqn 13.140
h_v = 0.943 * ((X/Y)^(1/4)) ;
//For Horizontal mounting of condenser, eqn 13.150
h_h = 0.725 * ((X/Z)^(1/4)) ;
//The higher heat transfer coefficient corresponds to better mounting option!
end Ex13_14;