//Foust A. S.,Principles of Unit Operations, 2nd Edition, Wiley India (P.) Ltd., Delhi, 2010
//Chapter 13: Fundamentals of Transfer Mechanisms
//Example 13.2 Page 252
//Title: Velocity Calculation
//--------------------------------------------------
model Ex13_2
//--------------------------------------------------
//Parameter Section
parameter Real L(unit = "ft")=100 "Length of Smooth Tube";
parameter Real D(unit = "ft")=3/12 "Diameter of Smooth Tube";
parameter Real rho(unit = "lb/(ft^3)")=60 "Density of Oil";
parameter Real delP(unit = "lbf/(ft^2)")=548 "Pressure Drop through the Tube";
//Viscosity of Oil = 5 cP,converted to fps units
parameter Real mu(unit = "lb/(ft.s)")=5*6.72e-4 "Viscosity of Oil";
parameter Real gc(unit = "ft/(s^2)")=32.2 "Gravitational constant";
//--------------------------------------------------
//Variable Section
Real RHS(unit = "NULL") "RHS of Friction factor Correlation";
Real v(unit = "ft/s") "Mean Velocity of Oil";
Real NRe(unit = "NULL") "Reynolds Number";
//--------------------------------------------------
//Library Section
extends Modelica.Math;
extends Modelica.Blocks.Math;
//--------------------------------------------------
//Equation Section
equation
//Assume Turbulent Flow
//Expanding Eqn 13.17 with f and NRe expressions
RHS = (2 * log10((D*rho/mu)* sqrt((2*delP*gc*D)/(L*rho)))) - 0.8;
v = sqrt(((RHS^2)*2*delP*gc*D)/(L*rho));
//To check whether initial assumption of Turbulence is Valid,
NRe = (D * v * rho)/mu;

end Ex13_2;