//Foust A. S.,Principles of Unit Operations, 2nd Edition, Wiley India (P.) Ltd., Delhi, 2010
//Chapter 13: Fundamentals of Transfer Mechanisms
//Example 13.5 Page 258
//Title: Entry Length Calculation
//--------------------------------------------------
model Ex13_5
//--------------------------------------------------
//Parameter Section
//Water at 70 degF is the fluid flowing through the tube
parameter Real D(unit = "ft")=0.5/12 "Diameter of Tube";
parameter Real rho(unit = "lb/(ft^3)")=62.4 "Density of Water";
parameter Real mu(unit = "lb/(ft.s)")=1*6.72e-4 "Viscosity of Water";
parameter Real v(unit = "ft/s")=0.1 "Velocity of Water";
 //--------------------------------------------------
//Variable Section
Real NRe(unit = "NULL") "Reynolds Number";
Real Le(unit = "ft") "Entry Length";
//--------------------------------------------------
//Equation Section
equation
NRe = (D * v * rho)/mu;
//Flow is found to be Laminar
Le = 0.0575 * D * NRe;

end Ex13_5;