//Foust A. S.,Principles of Unit Operations, 2nd Edition, Wiley India (P.) Ltd., Delhi, 2010
//Chapter 13: Fundamentals of Transfer Mechanisms
//Example 13.8 Page 268
//Title: Wetted-Wall Column:Air-CO2 mixture with water
//----------------------------------------------------
model Ex13_8
//----------------------------------------------------
//Parameter Section
parameter Real d(unit = "ft")=2/12 "Inside Diameter of column";
parameter Real v(unit = "ft/s")=3 "Velocity of the mixture";
parameter Real ya(unit = "NULL")=0.1 "Mole fraction of CO2 in air at point 1";
parameter Real xa1(unit = "NULL")=0.005 "Mole fraction of CO2 in liquid interface at point 1";
parameter Real p(unit = "atm")=1 "Normal pressure";
parameter Real pt(unit = "atm")=10 "System pressure";
parameter Real T(unit = "K")=298 "System Temperature";
parameter Real R(unit = "(atm.ft3)/(lbmol.degR)")=0.729 "Gas Constant";
//From Appendix D-11, for CO2-Air system,at 1 atm & 25 degC,
parameter Real D1(unit = "cm2/s")=0.164 "Diffusivity";
parameter Real NSc(unit = "NULL")=0.94 "Schmidt Number";
parameter Real H(unit = "atm/mol")=1640 "Henry's Constant, appendix D-3";
//Properties of air at 25 degC,
parameter Real mu_b(unit = "cP")=0.018 "Viscosity";
parameter Real rho_b(unit = "lb/ft3")=0.0808 "Density";
//----------------------------------------------------
//Variable Section
Real D2(unit = "cm2/s") "Diffusivity at 10 atm";
Real pa(unit = "atm") "Partial Pr. of CO2";
Real pa1(unit = "atm") "Partial Pr. of CO2 at point 1";
Real rho_b10(unit = "lb/ft3") "Air density at 10 atm";
Real NRe(unit = "NULL") "Reynolds Number";
Real pblm(unit = "atm") "Log mean of partial pr. of air";
Real kc(unit = "lbmol/(hr.ft2.(lbmol/ft3))") "Mass transfer coefficient";
Real Na_by_A(unit = "lbmol/(hr.ft2)") "Mass Flux of CO2";
//----------------------------------------------------
//Library Section
extends Modelica.Math;
//----------------------------------------------------
//Equation Section
equation
D2 = (D1 * p * 3600)/(pt * (30.5 ^2)) ; //ft2/hr conversion
pa = ya * pt;
pa1 = H * xa1;
rho_b10 = rho_b * (273/T) * (pt/p);
NRe = (d * v * rho_b10)/(mu_b * 6.72e-4);
pblm = (pa - pa1)/log((pt-pa1)/(pt-pa));
//Using eqn 13.70
kc = 0.023 * (D2/d) * (pt/pblm) * (NRe ^ 0.83) * (NSc ^ 0.33);
//By eqn 13.68
Na_by_A = - (kc/(R*(T*1.8))) * (pa1-pa);
//Negative sign indicates that diffusion takes place from wall to centre!

end Ex13_8;