//Foust A. S.,Principles of Unit Operations, 2nd Edition, Wiley India (P.) Ltd., Delhi, 2010
//Chapter 17: Simultaneous Heat and Mass Transfer-Humidification
//Example 17. Page 436
//Title: Enthalpy of air
//--------------------------------------------------
model Ex17_2
//--------------------------------------------------
//Parameter Section
parameter Real T(unit = "degC")=80 "Temperature of air @ 10% humidity";
parameter Real T0(unit = "degC")=0 "Temperature of dry air";
parameter Real Y(unit = "mol H2O/mol dry air")=0.088 ;
parameter Real cb(unit = "J/(mol.degC)")=29.08 "Specific heat of air";
parameter Real ca(unit = "J/(mol.degC)")=33.89 "Specific heat of water vapour";
parameter Real lambda(unit = "J/mol")=45070 "Latent Heat";
parameter Real Hsa(unit = "J/mol")=44000 "Enthalpy of saturated air";
parameter Real Ha(unit = "J/mol")=2300 "Enthalpy of dry air";
parameter Real P(unit = "NULL")=0.1 "10% Percent Saturation";
//--------------------------------------------------
//Variable Section
Real H1(unit = "J/mol") "Enthalpy of air by Eqn 17.10";
Real H2(unit = "J/mol") "Enthalpy of air at 10% saturation";
//--------------------------------------------------
//Equation Section
equation
//From Eqn 17.10,
H1 = (cb*(T-T0)) + Y*((ca*(T-T0)) + lambda);
//From Eqn 17.36,
H2 = Ha + ((Hsa-Ha)*P) ;

end Ex17_2;