//Foust A. S.,Principles of Unit Operations, 2nd Edition, Wiley India (P.) Ltd., Delhi, 2010
//Chapter 18: Simultaneous Heat and Mass Transfer-Drying
//Example 18.2 Page 469
//Title: Drying time for raw cotton in Tunnel Drier
//--------------------------------------------------
model Ex18_2
//--------------------------------------------------
//Parameter Section
parameter Real Tw(unit = "degF")=120 "Wet Bulb Temperature";
parameter Real T0(unit = "degF")=80 "Initial Temperature of cotton";
parameter Real T2(unit = "degF")=200 "Temperature of entering air";
parameter Real Tf(unit = "degF")=150 "Temperature of cotton at exit";
parameter Real G(unit = "lb/(hr.ft2)")=500 "Mass flow rate of cotton";
parameter Real X0(unit = "g of water/g of dry dolids")=1 "Initial Moisture Content";
parameter Real Xf(unit = "g of water/g of dry dolids")=0.1 "Final Moisture Content";
parameter Real Xc(unit = "g of water/g of dry dolids")=0.4 "Critical moisture content";
parameter Real Yf(unit = "mol of water/mol of dry air")=0.098 "Mole ratio of moisture in actual air";
parameter Real cp(unit = "Btu/(lb.degF)")=0.35 "Specific Heat of dry Cotton";
parameter Real lambda(unit = "Btu/lb")=1025 ;
parameter Real w_air(unit = "lb.air/lb.dry cotton")=60 "Air flow rate";
parameter Real delta_H(unit = "Btu/lbmol")=3240 "Air Enthalpy";
//Since the stock layer is 0.5" deep & conveyor area is 1 ft^2,
parameter Real ws(unit = "lb.dry cotton")=1.82 "Solids Held";
//--------------------------------------------------
//Variable Section
Real Y0(unit = "lbmol of water/lbmol of dry air")"Humidity of air leaving" ;
Real Yc(unit = "lbmol of water/lbmol of dry air")"Humidity at critical moistur content" ;
Real delta_H2(unit = "Btu/lbmol") "Enthalpy difference at pt.2";
Real H2(unit = "Btu/lbmol") "Enthalpy of entering air";
Real delta_H3(unit = "Btu/lbmol") "Enthalpy difference at pt.3";
Real H_exit(unit = "Btu/lbmol") "Enthalpy of air leaving";
Real hv(unit = "Btu/(hr.degF.ft2)") "Heat Transfer Coefficient by eqn18.12";
Real q_fw(unit = "Btu/ft2 of conveyor") "Heat Content during the final warm-up period";
Real q_iw(unit = "Btu/ft2 of conveyor") "Heat Content during the initial warm-up period";
Real delta_T_lm1(unit = "degF") "Log Mean T difference during final warm-up";
Real delta_T_lm2(unit = "degF") "Log Mean T difference during constant rate period";
Real delta_T_lm3(unit = "degF") "Log Mean T difference during falling rate period";
Real delta_T_lm4(unit = "degF") "Log Mean T difference during initial warm-up";
Real t1(unit = "hr") "Time taken for final warm-up";
Real t2(unit = "hr") "Time for constant rate period";
Real t3(unit = "hr") "Time for falling rate period";
Real t4(unit = "hr") "Time taken for initial warm-up";
Real t(unit = "hr") "Total time for drying";
//--------------------------------------------------
//Library Section
extends Modelica.Math;
//--------------------------------------------------
//Equation Section
equation
//MW of air = 29, cp of water = 1 & conveyor area = 1 ft^2
delta_H2 = ((X0*cp*(Tf-Tw)) + (Xf*1*(Tf-Tw))) * (29/w_air) ;
H2 = delta_H - delta_H2;
//Assuming no evaporation for the initial warm-up part
delta_H3 = ((X0*cp*(Tw-T0)) + (Xf*1*(Tw-T0))) * (29/w_air) ;
//Tw does not change at pt.3, so, H2=H3
H_exit = H2 - delta_H3;
hv = 0.0128 * (G^0.8);
(X0-Xf) = (Y0-Yf) * (18/29) * w_air;
(X0-Xc) = (Y0-Yc) * (18/29) * w_air;
//Final warm-up
delta_T_lm1 = ((T2-Tw)-(T2-Tf))/log((T2-Tw)/(T2-Tf));
q_fw = ws * ((X0*cp*(Tf-Tw)) + (Xf*1*(Tf-Tw)));
t1 = q_fw/(hv*1*delta_T_lm1);
//From Y0, temperature of stock warmed-up=T3=144 degF
//From Yc, temperature of stock at Xc=Tc=180 degF
//Constant Rate
delta_T_lm2 = ((180-Tw)-(144-Tw))/log((180-Tw)/(144-Tw));
t2 = ws * lambda * (X0-Xc)/(hv * 1 * delta_T_lm2);
//Falling Rate
delta_T_lm3 = ((T2-Tw)-(180-Tw))/log((T2-Tw)/(180-Tw));
//From equation (d)
t3 = (-ws * lambda/delta_T_lm3) * (1/4.75) * log(((4.75*Xf)-0.04)/((4.75*Xc)-0.04));
//Initial Warm-up
delta_T_lm4 = ((144-T0)-(144-Tw))/log((144-T0)/(144-Tw));
q_iw = ws * ((X0*cp*(Tw-T0)) + (X0*1*(Tw-T0)));
t4 = q_iw/(hv*1*delta_T_lm4);

t = t1+t2+t3+t4 ;
//Impractical Drying Time!

end Ex18_2;