//Foust A. S.,Principles of Unit Operations, 2nd Edition, Wiley India (P.) Ltd., Delhi, 2010
//Chapter 19:Simultaneous Heat and Mass Transfer-Evaporation & Crystallization
//Example 19.2 Page 507
//Title: Double Effect Evaporator-Backward Feed
//--------------------------------------------------
model Ex19_2
//--------------------------------------------------
//Parameter Section
parameter Real xF(unit = "NULL")=0.02 "Mole fraction of solid in feed";
parameter Real x1(unit = "NULL")=0.25 "Mole fraction of solid in product";
parameter Real L1(unit = "kg/hr")=1000 "Product flow rate";
parameter Real TF(unit = "degC")=30 "Feed temperature";
parameter Real Ts(unit = "degC")=164.9 "Steam Condensing temperature";
parameter Real Tc(unit = "degC")=38.9 "Condenser temperature";
parameter Real U1(unit = "W/(m2.K)")=2800 "Heat transfer Coefficient of 1st effect";
parameter Real U2(unit = "W/(m2.K)")=4000 "Heat transfer Coefficient of 2nd effect";
parameter Real A(unit = "m2")=200 "Projected Heating Area";
parameter Real cpF(unit = "kJ/(kg.K)")=4.187 "Specific Heat of feed";
parameter Real cp1(unit = "kJ/(kg.K)")=4.87 "Specific Heat of solution at 1st effect";
//--------------------------------------------------
//Variable Section
Real F(unit = "kg/hr") "Feed Rate";
Real V(unit = "kg/hr") "Exit vapour rate";
Real delta_T2_a(unit  = "degC") "Temperature difference at 2nd effect-Trial 1";
Real delta_T1_a(unit  = "degC") "Temperature difference at 1st effect-Trial 1";
Real T1a(unit  = "degC") "Temperature at 1st effect-Trial 1";
Real V1a(unit = "kg/hr") "Vapour rate from 1st effect-Trial 1";
Real delta_T2_b(unit  = "degC") "Temperature difference at 2nd effect-Trial 2";
Real delta_T1_b(unit  = "degC") "Temperature difference at 1st effect-Trial 2";
Real T1b(unit  = "degC") "Temperature at 1st effect-Trial 2";
Real V1b(unit = "kg/hr") "Vapour rate from 1st effect-Trial 2";
Real V2(unit = "kg/hr") "Vapour rate from 2nd effect";
Real L2(unit = "kg/hr") "Liquid leaving 2nd effect";
Real q1(unit = "kJ/kg") "Heat transfer from 1st effect";
Real Aavg(unit = "m2") "Heating Area required";
Real M(unit = "kg/hr") "Production Rate";
//--------------------------------------------------
//Equation Section
equation
F * xF = L1 * x1;
V = F - L1;
//Subscripts a & b denote trials 1 & 2 resp.
//Trial 1
//Assuming q1 = q2(equal areas,equal heat transfer rates)
delta_T2_a + ((U2/U1)*delta_T2_a) = Ts-Tc ;
delta_T1_a = Ts - Tc - delta_T2_a ;
T1a = Ts - delta_T1_a ;
//From T1a, using steam tables, H1=2661.2 kJ/kg, lambda_v1=2281.3 kJ./kg, H2=2571.9 kJ/kg
//Hence by equation (i)
V1a = ((2571.9*V)+(L1*T1a*cp1)-(F*TF*cpF)) / ((2*2281.3)+2571.9-2661.2) ;
//V1actual is found to be 1.1 times V1 calculated
//Trial 2 - Assumption: q1=1.1*q2
delta_T2_b + (1.1*(U2/U1)*delta_T2_b) = Ts-Tc ;
delta_T1_b = Ts - Tc - delta_T2_b ;
T1b = Ts - delta_T1_b ;
//From T1b, using steam tables, H1=2565.6 kJ/kg, lambda_v1=2288.6 kJ./kg, H2=2671 kJ/kg
//Hence by equation (i)
V1b = ((2671*V)+(L1*T1b*cp1)-(F*TF*cpF)) / ((2*2288.6)+2671-2565.6) ;
L2 = L1+V1b;
V2 = V-V1b;
//T2=Ts-delta_T2b=115.9 & cp2 = 1; Hence in eqn (d),h2=115.9 kJ/kg
q1 = (V1b*2565.6)+(L1*T1b*cp1)-(L2*115.9) ;
Aavg = q1/((U1*3.6)*(Ts-T1b)) ;
M = (A/Aavg) * L1 ;

end Ex19_2;