//Foust A. S.,Principles of Unit Operations, 2nd Edition, Wiley India (P.) Ltd., Delhi, 2010
//Chapter 20: The Energy Balance in Flow Systems
//Example 20.1 Page 544
//Title: Net Heat Input to Air
//--------------------------------------------------
model Ex20_1
//--------------------------------------------------
//Parameter Section
parameter Real m(unit = "kg/s")=0.1 "Mass flow rate of air";
parameter Real g(unit = "m/s2")=9.8 "Acceleration due to gravity";
parameter Real gc(unit = "(kg.m)/(s2.N)")=1 ;
parameter Real T1(unit = "K")=293 "Initial Temperature";
parameter Real T2(unit = "K")=363 "Final Temperature";
parameter Real del_z(unit = "m")=4 "Height of exchanger (Datum plane)";
parameter Real v1(unit = "m/s")=5 "Velocity of inlet air";
parameter Real P1(unit = "kN/m2")=120 "Pressure of entering air";
parameter Real del_P(unit = "kN/m2")=10 "Pressure drop";
//Assuming gas to obey ideal gas law
parameter Real cp(unit = "J/(kg.degC)")=1000 "Specific heat of gas";
//--------------------------------------------------
//Variable Section
Real v2(unit = "m/s") "Outlet Velocity";
Real del_H(unit = "J/kg") "Enthalpy change";
Real Q(unit = "J/kg") "Heat input to air";
Real Q1(unit = "J/s") "Net heat input to air";
//--------------------------------------------------
//Equation Section
equation
v2 = v1 * (T2/T1) * (P1/(P1-del_P)) ;
del_H = cp * (T2-T1);
//From Eqn 20.9, since the kinetic energy is negligible,
Q = del_H + (del_z * g/gc);
Q1 = Q * m ;
end Ex20_1;