//Foust A. S.,Principles of Unit Operations, 2nd Edition, Wiley India (P.) Ltd., Delhi, 2010
//Chapter 20: The Energy Balance in Flow Systems
//Example 20.4 Page 555
//Title: Pumping of Ethanol to Reactor
//--------------------------------------------------
model Ex20_4
//--------------------------------------------------
//Parameter Section
parameter Real rho(unit = "kgg/m3")=820 "Density of Ethanol";
parameter Real mu(unit = "(N.s)/m2")=0.9e-3 "Viscosity of Ethanol";
parameter Real D(unit = "m")=0.05 "Diameter of tube";
parameter Real L(unit = "m")=40 "Length of tube";
parameter Real P1(unit = "N/m2")=280e+3 "Pressure at pt.1";
parameter Real P2(unit = "N/m2")=140e+3 "Pressure at pt.2";
//--------------------------------------------------
//Variable Section
Real F(unit = "(N.m)/kg") "Frictional Loss";
Real S(unit = "m2") "Cross-sectional area of tube";
Real X(unit = "") "Term in equation 20.23";
Real v_avg(unit = "m/s") "Average velocity in tube";
Real Q(unit = "m3/s") "Volumetric flow rate of ethanol";
//--------------------------------------------------
//Libraries Section
extends Modelica.Constants;
extends Modelica.Math;
//--------------------------------------------------
//Equation Section
equation
//Since v1 = v2 for incompressible fluids
F = (P1-P2)/rho ;
S = pi * (D^2)/4 ;
//By eqn 20.23 
X = (D * rho/mu) * sqrt((2*D*F)/L) ;
//Using value of X, from Appendix C-4
v_avg/sqrt((2*D*F)/L) = 7.9 ;
Q = v_avg * S ;

end Ex20_4;