//Foust A. S.,Principles of Unit Operations, 2nd Edition, Wiley India (P.) Ltd., Delhi, 2010
//Chapter 20: The Energy Balance in Flow Systems
//Example 20.5 Page 556
//Title: MeOH delivery to Synthesis Plant
//--------------------------------------------------
model Ex20_5
//--------------------------------------------------
//Parameter Section
parameter Real M(unit = "lb/lbmol")=16 "MW of Methane";
parameter Real R(unit = "ft-lbf/(lbmol.degR)")=1545.35 "Gas Constant";
parameter Real Tav(unit = "degR")=(((60+75)/2)+459.67) "Average Temperature";
parameter Real mu2(unit = "lb/(ft.s)")=0.011 "Viscosity at compressor outlet";
parameter Real mu1(unit = "lb/(ft.s)")=0.012 "Viscosity at pipe in plant";
parameter Real Q(unit = "ft3/s")=150e+6 "Flow Rate of Methane";
parameter Real D(unit = "ft")=2 "Diameter of pipe";
parameter Real L(unit = "ft")=(2*5280) "Pipe Length";
parameter Real P2(unit = "psia")=(10+14.7) "Pressure at Compressor outlet";
parameter Real f(unit = "")=0.0129 "Average frictional factor";
//--------------------------------------------------
//Variable Section
Real w(unit = "lb/s") "Mass flow rate of methane";
Real A(unit = "ft2") "Cross-sectional area";
Real G(unit = "lb/(s.ft2)") "Mass Velocity";
Real NRe_2(unit = "") "Reynolds No. at Compressor Outlet";
Real NRe_1(unit = "") "Reynolds No. at pipe in Plant";
Real X(unit = "");
Real Y(unit = "");
Real P1(unit = "psia") "Pressure at pipe in plant";
//--------------------------------------------------
//Libraries Section
extends Modelica.Constants;
extends Modelica.Math;
//--------------------------------------------------
//Equation Section
equation
w = ((Q*M)/(24*3600)) * (492/(359*520)) ;
A = pi*(D^2)/4 ; 
G = w/A ;
NRe_2 = (D*G)/(mu2*6.72e-4) ;
NRe_1 = NRe_2 * (mu2/mu1) ;
//For the NRe value obtained, alpha=0.98 from fig.20.2
//By perfect gas law,eqn20.3 & eqn (d),
//Assuming first term is negligible,
X = f*(G^2)*R*Tav*L ;
Y = 32.2*D*M ;
P1 = sqrt((X/Y) + ((144*P2)^2))/144;
//Assumption contributes to 0.16% error in final answer.

end Ex20_5;