//Foust A. S.,Principles of Unit Operations, 2nd Edition, Wiley India (P.) Ltd., Delhi, 2010
//Chapter 21: Fluid Motive Devices
//Example 21.4 Page 595
//Title: Pump type & size
//--------------------------------------------------
model Ex21_4
//--------------------------------------------------
//Parameter Section
parameter Real n(unit = "rpm")=1800 "Assumed Operating Speed";
parameter Real Q(unit = "gal/min")=300 "Liquid flow rate";
parameter Real H(unit = "ft")=70 "Head of liquid";
//--------------------------------------------------
//Variable Section
Real Ns(unit = "rpm") "Specific speed of pump";
//--------------------------------------------------
//Library Section
extends Modelica.Math;
//--------------------------------------------------
//Equation Section
equation
//High Q & high H would require Centrifugal Pump
//By Eqn 21.8
Ns = (n * sqrt(Q))/(H^0.75) ;
//From Ns value & Figure 21.19, standard centrifugal pump is suggested
//From Figure 21.33a, pump size is 3-in discharge line,4-in suction line & impeller size not more than 10-in

end Ex21_4;