//Foust A. S.,Principles of Unit Operations, 2nd Edition, Wiley India (P.) Ltd., Delhi, 2010
//Chapter 21: Fluid Motive Devices
//Example 21.3 Page 592
//Title: Compressor type & Specific speed
//--------------------------------------------------
model Ex21_5
//--------------------------------------------------
//Parameter Section
parameter Real Q(unit = "ft3/min")=100000 "Air flow rate";
parameter Real Pg(unit = "psi g")=40 "Discharge Pressure";
//Assumptions
parameter Real n(unit = "rpm")=3500 "Operating Speed";
parameter Real D(unit = "ft")=2 "Radial compressor diameter";
//At 14.7 psia and 70 degF
parameter Real rho_air(unit = "lb/ft3")=0.075 "Density of air";
//--------------------------------------------------
//Variable Section
Real H(unit = "ft") "Head developed";
Real Ns(unit = "rpm") "Specific speed of compressor";
Real Ds(unit = "ft") "Specific diameter of compressor";
//--------------------------------------------------
//Library Section
extends Modelica.Math;
//--------------------------------------------------
//Equation Section
equation
H = (Pg*144)/rho_air ;
Ns = (n * sqrt(Q/60))/(H^0.75) ;
Ds = (D * (H^0.25))/sqrt(Q/60) ;

end Ex21_5;