//Foust A. S.,Principles of Unit Operations, 2nd Edition, Wiley India (P.) Ltd., Delhi, 2010
//Chapter 6: Countercurrent Multistage Operations With Reflux
//Example 6.2 Page 84
//Title: Distillation-Condenser & Reboiler Duty
//-------------------------------------------------------------
model Ex6_2
//------------------------------------------------------------- 
//Parameter Section
parameter Real F(unit = "lb mole/hr")=100 "Total Feed";
parameter Real zF(unit = "NULL")=0.3 "Mole fraction of Alcohol in Feed";
parameter Real xD(unit = "NULL")=0.8 "Mole fraction of Alcohol in Distillate";
//From Figure 6.10
parameter Real QSB(unit = "Btu/lb mole")=31500 "Amount of Heat added to the reboiler";
parameter Real QCD(unit = "Btu/lb mole")=54400 "Amount of Heat removed from the condenser";
//-------------------------------------------------------------
//Variable Section
Real Da(unit = "lb mole/hr") "Amount of Alcohol in Distillate";
Real D(unit = "lb mole/hr") "Total Distillate";
Real B(unit = "lb mole/hr") "Total Bottom Product";
Real xB(unit = "NULL") "Mole fraction of Alcohol in Bottom Product";
Real qS(unit = "Btu/hr") "Reboiler Duty";
Real qC(unit = "Btu/hr") "Condenser Duty";
//-------------------------------------------------------------
//Equation Section
equation
Da = 0.95 * zF * F;
D = Da/xD;
B = F-D;
xB = 1.5/B;
qS = QSB * B;
qC = QCD * D;

end Ex6_2;
