//Foust A. S.,Principles of Unit Operations, 2nd Edition, Wiley India (P.) Ltd., Delhi, 2010
//Chapter 7: Simplified Calculation Methods
//Example 7.1 Page 100
//Title: Minimum Oil Requirement
//--------------------------------------------
model Ex7_1
//--------------------------------------------
//Parameter Section
parameter Real Pa(unit = "mm Hg")=103 "Vapour Pressure of Benzene at 80 degF";
parameter Real P(unit = "mm Hg")=760 "Total Pressure";
parameter Real V(unit = "lb moles/hr")=600 "Flow Rate of Entering Gas";
parameter Real ya(unit = "NULL")=0.05 "Mole fraction of Benzene in Entering Gas";
parameter Real MW(unit = "lb/lb mole")=200 "Average Molecular Weight of Oil";
//--------------------------------------------
//Variable Section
Real YN1(unit = "NULL") "Mole Ratio of Benzene in gas fed (YN+1)";
Real Va(unit = "lb moles") "Amount of Benzene in leaving gas";
Real V1(unit = "lb moles") "Amount of Air in leaving gas";
Real Y1(unit = "lb mole Benzene/lb mole Air") "Mole Ratio of Benzene in gas leaving";
Real LVmin(unit = "NULL") "(L'/V')min";
Real Lmin(unit = "lb moles/hr") "Minimum Oil Rate";
Real LVact(unit = "NULL") "(L'/V')actual";
Real Lact(unit = "lb moles/hr") "Actual Flow Rate of Oil";
//--------------------------------------------
//Equation Section
equation
YN1 = ya/(1-ya);
Va = 0.1 * ya * V "90% Recovery of Benzene";
V1 = (1-ya)*V;
Y1 = Va/V1;
LVmin = (YN1-Y1)/(0.52-0) "From Figure 7.3,Page 101";
Lmin = LVmin * V1 * MW;
LVact = 1.5 * LVmin;
Lact = LVact * V1 * MW;

end Ex7_1;