//Foust A. S.,Principles of Unit Operations, 2nd Edition, Wiley India (P.) Ltd., Delhi, 2010
//Chapter 7: Simplified Calculation Methods
//Example 7.2 Page 103
//Title: No. of Equilibrium Stages
//--------------------------------------------
model Ex7_2
//--------------------------------------------
//Parameter Section
parameter Real F(unit = "moles")=100 "Total Feed (Basis)";
parameter Real alphaab(unit = "NULL")=2 "Realtive Volatility of a to b";
parameter Real zF(unit = "NULL")=0.35 "Composition of a in Feed";
parameter Real i(unit = "NULL")=1/2 "Feed is half vapour";
parameter Real R(unit = "NULL")=4 "Reflux Ratio";
parameter Real xD(unit = "NULL")=0.93 "Compostion of a in Distillate";
parameter Real d(unit = "NULL")=0.96 "Percent of a among all product in Distillate";
//--------------------------------------------
//Variable Section
Real mi(unit = "NULL") "Slope of i-Line";
Real me(unit = "NULL") "Slope of Enriching Operating Line";
Real xB(unit = "NULL") "Bottom Composition of a";
Real Da(unit = "moles") "Moles of a in Distillate";
Real Ba(unit = "moles") "Moles of a in Bottom";
Real D(unit = "moles") "Total Moles of Distillate";
Real B(unit = "moles") "Total Moles of Bottom";
Real y(unit = "NULL") "Vapour Composition of a at x=0.93";
//--------------------------------------------
//Equation Section
equation
mi = i/(i-1);
me = R/(R+1);
Da = F*zF*d;
Ba = (F*zF)-Da;
D = Da/xD;
B = F-D;
xB = Ba/B;
y = xD/(R+1);
//From Figure 7.5 Pg 104
//No. of Stages in Enriching Section = 7.5
//No. of Stages in Stripping Section = 9.5

end Ex7_2;