//Foust A. S.,Principles of Unit Operations, 2nd Edition, Wiley India (P.) Ltd., Delhi, 2010
//Chapter 9: Molecular Transport Mechanism
//Example 9.10 Page 178
//Title: Mixture Diffusivity-Gilliland Correlation
//--------------------------------------------------
model Ex9_10
//--------------------------------------------------
//Parameter Section
parameter Real T(unit = "K")=298 "Temperature 25 degC";
parameter Real Ma(unit = "kg/mol")=44e-3 "Molecular Weight of Carbon Dioxide";
parameter Real Mb(unit = "kg/mol")=28e-3 "Molecular Weight of Nitrogen";
parameter Real P(unit  = "N/(m^2)")=1.013e+5 "Atmospheric pressure";
//From Appendix D-7
parameter Real Va(unit = "(m^3)/mol")=34.2e-6 "Molar Volume of Carbon Dioxide";
parameter Real Vb(unit = "(m^3)/mol")=31.2e-6 "Molar Volume of Nitrogen";
//--------------------------------------------------
//Variable Section
Real D(unit = "(m^2)/s")"Mass Diffusivity of Mixture at 25 degC and 1 atm";
//--------------------------------------------------
//Library Section
extends Modelica.Blocks.Math;
//--------------------------------------------------
//Equation Section
equation
D = (1.38e-7 * sqrt((T^3)*((1/Ma)+(1/Mb))))/(P * (((Va^(1/3)) + (Vb^(1/3)))^2)) ;

end Ex9_10;