//Foust A. S.,Principles of Unit Operations, 2nd Edition, Wiley India (P.) Ltd., Delhi, 2010
//Chapter 9: Molecular Transport Mechanism
//Example 9.2 Page 168
//Title: Rate of Conduction through Copper Rod
//--------------------------------------------
model Ex9_2
//--------------------------------------------
//Parameter Section
parameter Real T1(unit = "degC")=300 "Temperature at one end";
parameter Real T2(unit = "degC")=20 "Temperature at the other end";
parameter Real k(unit = "J/(s.(m^2))(degC/m)")=1.36e+6 "Average Thermal Conductivity";
//Copper Rod Dimensions
parameter Real x1(unit = "m")=0;
parameter Real x2(unit = "m")=0.15;
parameter Real d(unit = "m")=0.002;
//--------------------------------------------
//Variable Section
Real A(unit = "m^2") "Cross-Sectional Area";
Real q(unit = "J/s") "Rate of Conduction through the Copper Rod";
//--------------------------------------------
//Library section
extends Modelica.Constants;
//--------------------------------------------
//Equation Section
equation
A = pi * ((d^2)/4);
q = -(k * A) * (T2-T1)/(x2-x1);

end Ex9_2;