model Ex12_1 "linear regression"
 function param
  input Integer n;
  input Real[n] y;
  input Real[n] x;
  output Real a0;
  output Real a1;
  output Real yav;
 protected
  Real xy = 0;
  Real x2 = 0;
  Real xs = 0;
  Real ys = 0;
 algorithm
  for i in 1:n loop
    xy := xy + x[i] * y[i];
  end for;
  for i in 1:n loop
    x2 := x2 + x[i] * x[i];
  end for;
  for i in 1:n loop
    xs := xs + x[i];
  end for;
  for i in 1:n loop
    ys := ys + y[i];
  end for;
  a1 := (n * xy - xs * ys)/(n * x2 - xs * xs);
  a0 := ys/n - a1 * xs/n;
  yav := ys/n;
 end param;
 
  Real x;
  Real y;
  parameter Integer n = 7 "length of x and y";
  parameter Real[n] y_i = {0.5, 2.5, 2.0, 4.0, 3.5, 6.0, 5.5};
  parameter Real[n] x_i = {1, 2, 3, 4, 5, 6, 7};
  Real a1;
  Real a0;
  Real yav "y average";
  Real[n] e1 "error: (y_i - yav)^2";
  Real[n] e2 "error: (y_i - a0 - a1 * x_i)^2";
 equation
  x = time;
  (a0, a1, yav) = param(n, y_i, x_i);
  y = a0 + a1 * x;
  for i in 1:n loop
    e1[i] = (y_i[i] - yav)^2;
    e2[i] = (y_i[i] - a0 - a1 * x_i[i])^2;
  end for;
end Ex12_1;
