model Ex12_4 "linearization of power equation"
function param
  input Integer n;
  input Real[n] y;
  input Real[n] x;
  output Real a0;
  output Real a1;
 protected
  Real xy = 0;
  Real x2 = 0;
  Real xs = 0;
  Real ys = 0;
 algorithm
  for i in 1:n loop
    xy := xy + x[i] * y[i];
  end for;
  for i in 1:n loop
    x2 := x2 + x[i] * x[i];
  end for;
  for i in 1:n loop
    xs := xs + x[i];
  end for;
  for i in 1:n loop
    ys := ys + y[i];
  end for;
  a1 := (n * xy - xs * ys)/(n * x2 - xs * xs);
  a0 := ys/n - a1 * xs/n;
 end param;
 
 parameter Real[5] xi = {1,2,3,4,5};
 parameter Real[5] yi = {0.5,1.7,3.4,5.7,8.4};
 Real[5] logxi;
 Real[5] logyi;
 Real a1;
 Real a0;
 Real x;
 Real y;
equation
 for i in 1:5 loop
  logxi[i] = log10(xi[i]);
  logyi[i] = log10(yi[i]);
 end for;
 (a0, a1) = param(5, logyi, logxi);
 x = time;
 y = (10^a0) * (x^a1);
end Ex12_4;
