model Ex12_6 "multiple linear regression"
  function gausselim
   input Integer n;
   input Real[n, n] a0;
   input Real[n] b0;
   input Boolean y;
   output Real[n] x;
   protected
    Integer piv = 0;
    Real[n] temp_a = zeros(n);
    Real temp_b = 0;
    Real m = 0;
    Real max = 0;
    Real[n, n] a = zeros(n, n);
    Real[n] b = zeros(n);
    Real sum = 0;
   algorithm
   a := a0;
   b := b0;
  for i in 1:n-1 loop
   if y == true then
    max := abs(a[i,i]);
    piv := i;
    for j in i+1:n loop
      if abs(a[j,i]) > max then
        max := abs(a[j,i]);
        piv := j;
      end if;
    end for;
      for l in 1:n loop
        temp_a[l] := a[piv,l];
      end for;
      temp_b := b[piv];
      for t in 1:n loop
        a[piv,t] := a[i,t];
      end for;
      b[piv] := b[i];
      for p in 1:n loop
        a[i,p] := temp_a[p];
      end for;
      b[i] := temp_b;
     end if;
    for j in i+1:n loop
      m := -1*a[j,i]/a[i,i];
      for k in i:n loop
        a[j,k] := a[j,k] + m * a[i,k];
      end for;
      b[j] := b[j] + m * b[i];
    end for;
  end for;
  x := zeros(n);
    for i in n:-1:1 loop
      sum := 0;
      for j in i+1:n loop
        sum := sum + a[i,j] * x[j];
      end for;
      x[i] := (b[i] - sum)/a[i,i];
    end for;
  end gausselim;
  
  Real[6] x1i;
  Real[6] x2i;
  Real[6] yi;
  Real[6] x1_2;
  Real[6] x2_2;
  Real[6] x1x2;
  Real[6] x1y;
  Real[6] x2y;
  Real[3] a "coefficients";
  Real x1;
  Real y;
  Real x2;
 equation
  x1 = time;
  x2 = time;
  x1i = {0,2,2.5,1,4,7};
  x2i = {0,1,2,3,6,2};
  yi = {5,10,9,0,3,27};
  for i in 1:6 loop
    x1_2[i] = x1i[i] * x1i[i];
    x2_2[i] = x2i[i] * x2i[i];
    x1x2[i] = x1i[i] * x2i[i];
    x1y[i] = x1i[i] * yi[i];
    x2y[i] = x2i[i] * yi[i];
  end for;
  a = gausselim(3, {{6, 16.5, 14}, {16.5, 76.25, 48}, {14, 48, 54}}, {54, 243.5, 100}, false);
  y = a[1] + a[2] * x1 + a[3] * x2;
  
end Ex12_6;
