model Ex16_2 "Multiple applications of trapezoidal rule"

function f
    input Real x;
    output Real y;
   algorithm
    y := 0.2 + 25*x - 200*x^2 + 675 * x^3 - 900*x^4 + 400 * x^5;
  end f;
  
  function fd
    input Real x;
    output Real y;
   algorithm
    y := 0.2*x + 25*x^2 / 2 - 200*x^3 / 3 + 675 * x^4 / 4 - 900*x^5 / 5 + 400 * x^6 / 6;
  end fd;
  
  parameter Real a = 0;
  parameter Real b = 0.8;
  Real c "mid point of a and b";
  Real I "value of integral using trapezoidal rule";
  Real Et "error";
  Real et "relative error";
 equation
  c = (b+a)/2;
  I = (b-a) * ( f(a) + 2 * f(c) + f(b) ) / 4;
  Et = fd(b) - fd(a) - I;
  et = Et / (fd(b) - fd(a)) * 100;
end Ex16_2;
