model Ex16_7 "trapezoidal rule with unequal segments"
  
  function f
    input Real x;
    output Real y;
   algorithm
    y := 0.2 + 25*x - 200*x^2 + 675 * x^3 - 900*x^4 + 400 * x^5;
  end f;
  
  function fd
    input Real x;
    output Real y;
   algorithm
    y := 0.2*x + 25*x^2 / 2 - 200*x^3 / 3 + 675 * x^4 / 4 - 900*x^5 / 5 + 400 * x^6 / 6;
  end fd;
  
  function int
    input Integer n;
    input Real[n] x;
    output Real I;
   algorithm
    I := 0;
    for i in 1:n-1 loop
      I := I + (x[i+1] - x[i]) * (f(x[i]) + f(x[i+1])) / 2;
    end for;
  end int;
  
  parameter Real[11] x = {0,0.12,0.22,0.32,0.36,0.40,0.44,0.54,0.64,0.70,0.80};
  Real[11] fx;
  Real I "integral";
  Real Et "error";
  Real et "relative error";
 equation
  for i in 1:11 loop
    fx[i] = f(x[i]);
  end for;
  I = int(11, x);
  Et = fd(x[11]) - fd(x[1]) - I;
  et = Et / (fd(x[11]) - fd(x[1])) * 100;
  
end Ex16_7;
