model Ex17_3 "Two point gauss lengendre formula"

  function f
    input Real x;
    output Real y;
   algorithm
    y := 0.2 + 25*x - 200*x^2 + 675 * x^3 - 900*x^4 + 400 * x^5;
  end f;
  
  function fd
    input Real x;
    output Real y;
   algorithm
    y := 0.2*x + 25*x^2 / 2 - 200*x^3 / 3 + 675 * x^4 / 4 - 900*x^5 / 5 + 400 * x^6 / 6;
  end fd;
  
  parameter Real a = 0;
  parameter Real b = 0.8;
  Real I;
  Real Et "error";
  Real et "relative error";
 equation
  I = 0.4 * f((b+a)/2 - (b-a)/2/1.732) + 0.4 * f((b+a)/2 + (b-a)/2/1.732);
  Et = fd(b) - fd(a) - I;
  et = Et / (fd(b) - fd(a)) * 100;
end Ex17_3;
