model Ex18_1 "High accuracy differentiation formulas"

  function f
    input Real x;
    output Real y;
   algorithm
    y := -0.1 * x^4 - 0.15 * x^3 - 0.5 * x^2 - 0.25 * x + 1.2;
  end f;
  
  function fd
    input Real x;
    output Real y;
   algorithm
    y := -0.1 * 4 * x^3 - 0.15 * 3 * x^2 - 0.5 * 2 * x - 0.25;
  end fd;
  
  parameter Real h = 0.25 "step size";
  parameter Real x0 = 0.5 "value pf x at which derivative is to be calculated";
  Real[5] xi;
  Real[5] fi;
  Real d2_b "derivative using backward difference of accuracy O(h^2)";
  Real d2_f "derivative forward difference of accuracy O(h^2)";
  Real d4_c "derivative centred difference of accuracy O(h^4)";
  Real d "true derivative at x0";
  Real e2_b "relative error using backward difference of accuracy O(h^2)";
  Real e2_f "relative error using forward difference of accuracy O(h^2)";
  Real e4_c "relative error using centred difference of accuracy O(h^4)";
 equation
  d = fd(x0);
  xi[1] = x0 - 2 * h;
  xi[2] = x0 - h;
  xi[3] = x0;
  xi[4] = x0 + h;
  xi[5] = x0 + 2*h;
  for i in 1:5 loop
    fi[i] = f(xi[i]);
  end for;
  d2_f = (-fi[5] + 4 * fi[4] - 3 * fi[3]) / (2 * h);
  d2_b = (3 * fi[3] - 4 * fi[2] + fi[1]) / (2 * h);
  d4_c = ( -fi[5] + 8 * fi[4] - 8 * fi[2] + fi[1]) / (12 * h);
  e2_b = abs((d - d2_b) / d) * 100;
  e2_f = abs((d - d2_f) / d) * 100;
  e4_c = abs((d - d4_c) / d) * 100;

end Ex18_1;
