model Ex20_6 "comparison of various second order R-K methods"
 function f
  input Real x;
  output Real fun;
 algorithm
  fun := -2 * x^3 + 12 * x^2 - 20 * x + 8.5;
 end f;
 
 parameter Real x0 = 0;
 parameter Real xf = 4;
 parameter Real h = 0.5;
 parameter Integer n = integer(ceil((xf-x0)/h));
 parameter Real y0 = 1;
 Real[n+1] x;
 Real[n+1] y_m "y values from mid-point method";
 Real[n+1] y_r "y values from ralston's method";
 Real[n+1] y_h "y values from heun's method";
equation
 x[1] = x0;
 y_m[1] = y0;
 y_r[1] = y0;
 y_h[1] = y0;
 for i in 1:n loop
  x[i+1] = x[i] + h;
  y_m[i+1] = y_m[i] + h * f(x[i] + h/2);
  y_r[i+1] = y_r[i] + h * (f(x[i])/3 + f(x[i] + 3/4*h)*2/3);
  y_h[i+1] = y_h[i] + h * (f(x[i])/2 + f(x[i] + h)/2);
  end for;
end Ex20_6;
