model Ex20_7 "fourth order RK method"
  function fa
    input Real x;
    input Real y;
    output Real fun;
   algorithm
    fun := -2 * x^3 + 12 * x^2 - 20 * x + 8.5 + 0 * y;
   end fa;
   
   function fb
    input Real x;
    input Real y;
    output Real fun;
   algorithm
    fun := 4 * exp(0.8 * x) - 0.5 * y;
   end fb;
   
   function ka 
    input Real h;
    input Real x;
    input Real y;
    output Real[4] k;
   algorithm
    k[1] := fa(x, y);
    k[2] := fa(x + h/2, y + k[1] * h/2);
    k[3] := fa(x + h/2, y + k[2] * h/2);
    k[4] := fa(x + h, y + k[3] * h);
   end ka;
   
   function kb 
    input Real h;
    input Real x;
    input Real y;
    output Real[4] k;
   algorithm
    k[1] := fb(x, y);
    k[2] := fb(x + h/2, y + k[1] * h/2);
    k[3] := fb(x + h/2, y + k[2] * h/2);
    k[4] := fb(x + h, y + k[3] * h);
   end kb;
   
   parameter Real h_a = 0.5 "step size for part a";
   parameter Real x0_a = 0 "initial x for part a";
   parameter Real y0_a = 1 "initial y for part a";
   Real y_a;
   Real[4] k_a "k values for part a"; 
   parameter Real h_b = 0.5 "step size for part b";
   parameter Real x0_b = 0 "initial x for part b";
   parameter Real y0_b = 2 "initial y for part b";
   Real y_b;
   Real[4] k_b "k values for part b";
  equation
   k_a = ka(h_a, x0_a, y0_a);
   k_b = kb(h_b, x0_b, y0_b);
   y_a = y0_a + h_a / 6 * (k_a[1] + 2 * (k_a[2] + k_a[3]) + k_a[4]);
   y_b = y0_b + h_b / 6 * (k_b[1] + 2 * (k_b[2] + k_b[3]) + k_b[4]);
   
end Ex20_7;
